﻿//////////////////////////////////////////////
// JsonExporter.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Exportable ;
	class Node ;
}

/// Includes ---------------------------------

// nkExport
#include "../Dll/DllDefines.h"

#include "ExporterLoadResult.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkExport
{
	class DLL_EXPORT_EXPORT JsonExporter final
	{			
		public :

			// Export
			static nkMemory::String exportObjectIntoString (Exportable* toExport) ;
			static nkMemory::String exportTreeIntoString (Node* rootNode) ;
			// Import
			static ExporterLoadResult importIntoTree (nkMemory::StringView strVal) ;

		private :

			// Constructor, destructor
			JsonExporter () = delete ;
			~JsonExporter () = delete ;
	} ;
}